//----------------------------------------------------------------------------//
//- CadPasswortAendern.pas ---------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog zum ndern des Administratorpasswortes                              //
//----------------------------------------------------------------------------//

unit CadPasswortAendern;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, CaoRegistry;

//------------------------------------------------------------------------------

type
  TCaDlgPasswortAendern = class(TCaDlgBaseDialog)
    m_GrpPasswort   : TGroupBox;
    m_LblPasswort1  : TLabel;
    m_EdtPasswort1  : TEdit;
    m_LblPasswort2  : TLabel;
    m_EdtPasswort2  : TEdit;

    //--------------------------------------------------------------------------

    procedure FormShow         (Sender: TObject);
    procedure FormCloseQuery   (Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

  //----------------------------------------------------------------------------

  private
    m_obRegistry: TCaoRegistry;

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------

  end; // TCaDlgPasswortAendern

//------------------------------------------------------------------------------

var
  CaDlgPasswortAendern: TCaDlgPasswortAendern;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst;

//------------------------------------------------------------------------------

procedure TCaDlgPasswortAendern.FormShow(Sender: TObject);
begin
  m_EdtPasswort1.Clear;
  m_EdtPasswort2.Clear;
  m_EdtPasswort1.SetFocus;
  inherited;
end; // TCaDlgPasswortAendern.FormShow

//------------------------------------------------------------------------------

procedure TCaDlgPasswortAendern.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  inherited;
  if CanClose and (ModalResult = mrOk) then begin
    if not (m_EdtPasswort1.Text = m_EdtPasswort2.Text) then begin
      CanClose := False;
      MessageDlg(c_sMeldungPasswortUngleich, mtError, [mbOk], 0);
      m_EdtPasswort2.SetFocus;
    end // if
    else begin
      m_obRegistry.WritePassword(m_EdtPasswort1.Text);
    end; // else
  end; // if
end; // TCaDlgPasswortAendern.FormCloseQuery

//------------------------------------------------------------------------------

procedure TCaDlgPasswortAendern.FormCreate(Sender: TObject);
begin
  inherited;
  m_obRegistry := TCaoRegistry.Create;
end; // TCaDlgPasswortAendern.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgPasswortAendern.FormDestroy(Sender: TObject);
begin
  m_obRegistry.Free;
  inherited;
end; // TCaDlgPasswortAendern.FormDestroy

//------------------------------------------------------------------------------

end. // CadPasswortAendern
